<?php
/* --------------------------------------------------------------
   Withdrawal.php 2020-04-21
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2019 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\Withdrawal\Interfaces;

use JsonSerializable;

/**
 * Interface Withdrawal
 * @package Gambio\Admin\Withdrawal\Interfaces
 */
interface Withdrawal extends JsonSerializable
{
    /**
     * Returns the ID.
     *
     * @return int|null
     */
    public function id(): ?int;
    
    
    /**
     * Returns the order ID,
     *
     * @return int|null
     */
    public function orderId(): ?int;
    
    
    /**
     * Returns the order creation date.
     *
     * @return string|null
     */
    public function orderCreationDate(): ?string;
    
    
    /**
     * Returns the order delivery date.
     *
     * @return string|null
     */
    public function orderDeliveryDate(): ?string;
    
    
    /**
     * Returns the customer ID.
     *
     * @return int|null
     */
    public function customerId(): ?int;
    
    
    /**
     * Returns the customer gender.
     *
     * @return string
     */
    public function customerGender(): string;
    
    
    /**
     * Returns the customer first name.
     *
     * @return string
     */
    public function customerFirstName(): string;
    
    
    /**
     * Returns the customer last name.
     *
     * @return string
     */
    public function customerLastName(): string;
    
    
    /**
     * Returns the customer street.
     *
     * @return string
     */
    public function customerStreet(): string;
    
    
    /**
     * Returns the customer post code.
     *
     * @return string
     */
    public function customerPostcode(): string;
    
    
    /**
     * Returns the customer city.
     *
     * @return string
     */
    public function customerCity(): string;
    
    
    /**
     * Returns the customer country.
     *
     * @return string
     */
    public function customerCountry(): string;
    
    
    /**
     * Returns the customer email.
     *
     * @return string
     */
    public function customerEmail(): string;
    
    
    /**
     * Returns the withdrawal date.
     *
     * @param string $format Datetime format
     *
     * @return string
     */
    public function date(string $format = 'Y-m-d H:i:s'): string;
    
    
    /**
     * Returns the content.
     *
     * @return string
     */
    public function content(): string;
    
    
    /**
     * Returns the "created by admin" flag.
     *
     * @return bool
     */
    public function wasCreatedByAdmin(): bool;
    
    
    /**
     * Returns the creation date.
     *
     * @return string|null
     */
    public function createdOn(string $format = 'Y-m-d H:i:s'): ?string;
    
    
    /**
     * Changes the related order of the withdrawal.
     *
     * @param WithdrawalOrderId $orderId
     */
    public function changeOrder(WithdrawalOrderId $orderId): void;
}